 ; Ŀ
 ;   Match properties with a pattern entity - Layer, Colour, Linetype.     
 ;   Copyright 1997, 2004 by Rocket Software Ltd.                          
 ;   Civilization consists largely of solutions that don't work            
 ;   to problems that don't exist.                                         
 ; 
 (DEFUN C:MP (/ ssdat pdat *error* ss enampt ssdata entt gnulay gnult gnucol)
 ; Ŀ
 ;   Define a couple of subroutines.                                       
 ;   Note that making subroutines local to the main function protects      
 ;   them from being overwritten by other routines or variables with the   
 ;   same name.  It also makes them inaccessible to other programs.        
 ; 
 ; Ŀ
 ;   Subroutine Ssdat - get certain entity data for a whole ss.            
 ;   Arguments: Ss, a selection set.                                       
 ;   Returns a list of a layer name, a colour, and a linetype.             
 ;   If any of these is not constant for all members of the ss then        
 ;   its place in the list reads "Varies."                                 
 ; 
 (DEFUN SSDAT (ss / num enam entt layy lint cola layall lintal collal)
  (setq num 0)
  (while (and (setq enam (ssname ss num))
              (not (and (= collal "Varies")
                        (= layall "Varies")
                        (= lintal "Varies"))))
         (setq num (1+ num))
         (setq entt (entget enam))
         (setq layy (cdr (assoc 8 entt)))
         (setq lint (cdr (assoc 6 entt)))
         (if (null lint) (setq lint "Bylayer"))
         (setq cola (cdr (assoc 62 entt)))
         (if (null cola) (setq cola "Bylayer"))
         (if (= cola 0) (setq cola "Byblock"))
         (cond ((null layall)
                (setq layall layy))
               ((/= layall layy)
                (setq layall "Varies")))
         (cond ((null lintal)
                (setq lintal lint))
               ((/= lintal lint)
                (setq lintal "Varies")))
         (cond ((null collal)
                (setq collal cola))
               ((/= collal cola)
                (setq collal "Varies"))))
 (list layall collal lintal))
 ; Ŀ
 ;   Ssdat end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Pdat - print certain entity data.                          
 ;   Arguments: Str, a descriptive string.                                 
 ;              Layy, a layer name.                                        
 ;              Coll, a colour.                                            
 ;              Litp, a linetype.                                          
 ; 
 (DEFUN PDAT (str layy coll litp)
  (write-line (strcat "\n" str
                      " Lay: " (strcase (substr layy 1 1))
                                (strcase (substr layy 2) t)
                      ",  Col: " (cond ((= coll 1)  "Red")
                                       ((= coll 2)  "Yellow")
                                       ((= coll 3)  "Green")
                                       ((= coll 4)  "Cyan")
                                       ((= coll 5)  "Blue")
                                       ((= coll 6)  "Magenta")
                                       ((= coll 7)  "White")
                                       ((= (type coll) 'INT)
                                        (itoa coll))
                                       ((= (type coll) 'STR)
                                        coll))
                      ",  Lt: " (strcase (substr litp 1 1))
                      (strcase (substr litp 2) t))))
 ; Ŀ
 ;   Pdat end.                                                             
 ; 

 ; Ŀ
 ;   Mp - the code.                                                        
 ; 
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Exit the dim command if we are therein - a number of functions and    
 ;   commands don't agree with it.                                         
 ; 
  (if (= "DIM" (substr (getvar "cmdnames") 1 3))
      (progn
           (command "exit")
           (write-line "\n")))
 ; Ŀ
 ;   Among them Entsel and Undo.                                           
 ; 
  (command "undo" "be")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make a clandestine error handler.                                     
 ; 
  (defun *error* (shk)
   (if (/= shk "Function cancelled") (write-line shk))
   (setvar "snapmode" snapp)
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Get entities to modify.                                               
 ; 
  (write-line "Pick stuff to transmute: ")
  (if (and (setq ss (ssget))
           (setq enampt (entsel "Select an ideal entity: ")))
      (progn
           (setq ssdata (ssdat ss))
           (setq entt (entget (car enampt)))
           (setq gnulay (cdr (assoc 8 entt)))
           (setq gnult (cdr (assoc 6 entt)))
           (if (null gnult) (setq gnult "Bylayer"))
           (setq gnucol (cdr (assoc 62 entt)))
           (if (null gnucol) (setq gnucol "Bylayer"))
           (if (= gnucol 0) (setq gnucol "Byblock"))
           (command "change" ss "" "p" "colour" gnucol
                                       "layer" gnulay
                                       "ltype" gnult "")
           (eval (cons 'pdat (cons "Old:" ssdata)))
           (pdat "New:" gnulay gnucol gnult))
      (write-line "\nUnable to proceed."))
  (setvar "snapmode" snapp)
  (command "undo" "end")
 (princ))